/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.client.gui;

import dev.doctor4t.wathe.game.GameFunctions;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoleAnnouncementTexts {
    public static final ArrayList<RoleAnnouncementText> ROLE_ANNOUNCEMENT_TEXTS = new ArrayList();
    public static final RoleAnnouncementText BLANK = RoleAnnouncementTexts.registerRoleAnnouncementText(new RoleAnnouncementText("", 0xFFFFFF));
    public static final RoleAnnouncementText CIVILIAN = RoleAnnouncementTexts.registerRoleAnnouncementText(new RoleAnnouncementText("civilian", 3597595));
    public static final RoleAnnouncementText VIGILANTE = RoleAnnouncementTexts.registerRoleAnnouncementText(new RoleAnnouncementText("vigilante", 1805029));
    public static final RoleAnnouncementText KILLER = RoleAnnouncementTexts.registerRoleAnnouncementText(new RoleAnnouncementText("killer", 12662840));
    public static final RoleAnnouncementText LOOSE_END = RoleAnnouncementTexts.registerRoleAnnouncementText(new RoleAnnouncementText("loose_end", 0x9F0000));

    public static RoleAnnouncementText registerRoleAnnouncementText(RoleAnnouncementText role) {
        ROLE_ANNOUNCEMENT_TEXTS.add(role);
        return role;
    }

    public static class RoleAnnouncementText {
        private final String name;
        public final int colour;
        public final class_2561 roleText;
        public final class_2561 titleText;
        public final class_2561 welcomeText;
        public final Function<Integer, class_2561> premiseText;
        public final Function<Integer, class_2561> goalText;
        public final class_2561 winText;

        public RoleAnnouncementText(String name, int colour) {
            this.name = name;
            this.colour = colour;
            this.roleText = class_2561.method_43471((String)("announcement.role." + this.name.toLowerCase())).method_54663(this.colour);
            this.titleText = class_2561.method_43471((String)("announcement.title." + this.name.toLowerCase())).method_54663(this.colour);
            this.welcomeText = class_2561.method_43469((String)"announcement.welcome", (Object[])new Object[]{this.roleText}).method_54663(0xF0F0F0);
            this.premiseText = count -> class_2561.method_43469((String)(count == 1 ? "announcement.premise" : "announcement.premises"), (Object[])new Object[]{count});
            this.goalText = count -> class_2561.method_43469((String)((count == 1 ? "announcement.goal." : "announcement.goals.") + this.name.toLowerCase()), (Object[])new Object[]{count}).method_54663(this.colour);
            this.winText = class_2561.method_43471((String)("announcement.win." + this.name.toLowerCase())).method_54663(this.colour);
        }

        public class_2561 getLoseText() {
            return this == KILLER ? RoleAnnouncementTexts.CIVILIAN.winText : RoleAnnouncementTexts.KILLER.winText;
        }

        @Nullable
        public class_2561 getEndText( @NotNull GameFunctions.WinStatus status, class_2561 winner) {
            return switch (status) {
                default -> throw new MatchException(null, null);
                case GameFunctions.WinStatus.NONE -> null;
                case GameFunctions.WinStatus.PASSENGERS, GameFunctions.WinStatus.TIME -> {
                    if (this == KILLER) {
                        yield this.getLoseText();
                    }
                    yield this.winText;
                }
                case GameFunctions.WinStatus.KILLERS -> {
                    if (this == KILLER) {
                        yield this.winText;
                    }
                    yield this.getLoseText();
                }
                case GameFunctions.WinStatus.LOOSE_END -> class_2561.method_43469((String)("announcement.win." + RoleAnnouncementTexts.LOOSE_END.name.toLowerCase()), (Object[])new Object[]{winner}).method_54663(RoleAnnouncementTexts.LOOSE_END.colour);
            };
        }
    }
}

